 
#ifndef _1_ODRM_TLKTST_UTIL_h_H
#define _1_ODRM_TLKTST_UTIL_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  5 December 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version ODRM_TLK_ATP_UTIL.h#1:incl:1
   *  \author Sagit Ben Tsur
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************************ Defines *******************************/

#include "DX_VOS_BaseTypes.h"
#include "ODRM_TLK_ATP_Defines.h"  
	

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 * 	ATP_LOG_TST_PRINT 		
 * 
 * Inputs:
 * 	DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 * 	const char format,... - the printf format.	 
 *  
 * Outputs:
 *   None	    					  		
 *
 * Description:																	
 * The following function handles the printings logging of the testing suite . 
 *        This function should be called by using the ATP_LOG_TST_PLOT macro
 *
 ******************************************************************************/							     
    #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        int ODRMTLK_LOG_TST( DxUint8_t level , const char *format,... );
    #endif

    #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        #define ODRMTLK_LOG_TST_PRINT(args) (ODRMTLK_LOG_TST args)
    #else
        #define ODRMTLK_LOG_TST_PRINT(args)   
    #endif	
/*****************************************************************************
 * Function Name:                                                           
 * 	TST_CheckErrorReturn 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char 	 TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char 	 TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 * 	DxError_t - Function error return		    					  		
 *
 * Description:																	
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation had Succeeded of failed	the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t ODRMTLK_TST_CheckErrorReturn(DxError_t TST_ErrorRet, 
							                          char 	  TST_FuncName[TST_FUNC_STRING_LEN],
							                          char 	  TST_SubTestName[TST_FUNC_STRING_LEN],
							                          char 	  TST_MasterTestName[TST_FUNC_STRING_LEN]);


#ifdef __cplusplus
}
#endif

#endif


